#!/usr/bin/perl

# trivial-search.pl - query a solr/lucene index

# Eric Lease Morgan <eric_morgan@infomotions.com>
# December 31, 2008 - first cut


# define
use constant SOLR => 'http://localhost:210/solr';

# require
use strict;
use WebService::Solr;

# initalize
my $solr = WebService::Solr->new( SOLR );

# sanity check
my $query = $ARGV[0];
if ( ! $query ) {

	print "Usage: $0 <query>\n";
	exit;
}

# search & get hits
my $response  = $solr->search( $query );
my @hits = $response->docs;

# display
print "\nYour search ($query) found " . ( $#hits + 1 ) . " document(s).\n\n";
foreach my $doc ( @hits ) {

	# slurp
	my $id          = $doc->value_for(  'id'          );
	my $title       = $doc->value_for(  'title'       );
	
	# echo
	print "           id: $id\n";
	print "        title: $title\n";
	print "\n";
	
}
